//
//  PeripheralDevice.swift
//  Orbis
//
//  Created by Shiri Ganesh on 9/22/17.
//  Copyright © 2017 KALSI. All rights reserved.
//

import UIKit
import CoreBluetooth

class PeripheralDevice: UIViewController,UITableViewDataSource, UITableViewDelegate{
    
    
    @IBOutlet weak var peripheralsList: UITableView!
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        
        //appDelegate.cManager.scanForPeripherals(withServices:[CBUUID.init(string: "1802")], options: nil)

        NotificationCenter.default.addObserver(self, selector: #selector(self.reloadList), name: NSNotification.Name(rawValue: "reloadList"), object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(self.navigater), name: NSNotification.Name(rawValue: "navigater"), object: nil)
        
    }
    
    
    func reloadList()  {
        peripheralsList.reloadData()
    }
    func navigater()  {
        self.navigationController?.popViewController(animated: false)

    }
    
    @IBAction func refreshList(_ sender: Any) {
        appDelegate.cManager.scanForPeripherals(withServices:[CBUUID.init(string: "1802")], options: nil)

    }
    
    // MARK: - Tableview

    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return appDelegate.peripherals.count
    }
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "customcell")!
        tableView.separatorStyle = .singleLine
        cell.textLabel?.text = appDelegate.peripherals[indexPath.row] as? String
        cell.textLabel?.textColor = UIColor.white
        cell.selectionStyle = .none
        return cell
    }

    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath){
        
        appDelegate.myDevice = appDelegate.peripheralDevices[indexPath.row] as! CBPeripheral
        
        if appDelegate.myDevice.state == .disconnected{
//            cManager.stopScan()
//            appDelegate.myDevice.delegate = self
            appDelegate.cManager.connect(appDelegate.myDevice, options: nil)

        }
        
    }
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat{
        return 50
    }
    func tableView(_ tableView: UITableView, editActionsForRowAt indexPath: IndexPath) -> [UITableViewRowAction]?{
        let delete = UITableViewRowAction(style: .destructive, title: "Disconnect") { (action, indexPath) in
            // delete item at indexPath
            appDelegate.willingtoReconnect = false
            appDelegate.cManager.cancelPeripheralConnection(appDelegate.peripheralDevices[indexPath.row] as! CBPeripheral)
            appDelegate.willingtoReconnect = false

            
        }
        return [delete]
    }
    
    
    @IBAction func GoBack(_ sender: Any) {
        self.navigationController?.popViewController(animated: true)
    }
    
    
    /*
    // MARK: - Navigation

    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        // Get the new view controller using segue.destinationViewController.
        // Pass the selected object to the new view controller.
    }
    */
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
}
